/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>
#include <Dialog.h>




#include <..\OriginLab\DialogEx.h>
#include <..\OriginLab\SplitterControl.h>
#include <..\OriginLab\DynaSplitter.h>
#include <GetNBox.h>
#include "ResDLL/SplitterRes.h"


typedef enum
{
	WORKBOOK_TAB,
	WORKSHEET_TAB
}TabType;


class TabSplitter : public TreeDynaSplitter
{
public:
	TabSplitter()
	{
		m_bReady = false;
		m_nSelectRowSetting = 0;
	}
	
	void Show(int tabtype)
	{
		m_bReady=false;
		if(tabtype == WORKBOOK_TAB)
			ShowList(m_trWorkbook, ATRN_STOP_LEVEL | 0);
		else if(tabtype == WORKSHEET_TAB)
			ShowList(m_trWorksheet, ATRN_STOP_LEVEL | 0);
		m_bReady = true;
		SelectRow(m_nSelectRowSetting);
	}

	void OnReady()
	{
		TreeDynaSplitter::OnReady();
	}
	
	void CreateWorkbook()
	{
		WorksheetPage wp;

		string pgname;
		int nwks;
		m_trWorkbook.page.pgname.GetValue(pgname);
		m_trWorkbook.pgctx.nworksheet.GetValue(nwks);

		int nRows,nCols;
		m_trWorksheet.Size.nCols.GetValue(nCols);
		m_trWorksheet.Size.nRows.GetValue(nRows);

		BOOL longname,units,comments;
		m_trWorksheet.column.context.longname.GetValue(longname);
		m_trWorksheet.column.context.units.GetValue(units);
		m_trWorksheet.column.context.comments.GetValue(comments);
	
		wp.Create("Origin");
		
		if(!wp.SetName(pgname))
			out_str("Can not use the Page Name:" + pgname);

		int tmp = nwks;
		while(--tmp)
			wp.AddLayer();
		
		Worksheet wks;
		TreeNode tr,trAutoRows;
		while(nwks--)
		{
			wks = wp.Layers(nwks);
			if(!wks)
				continue;
			tr = wks.GetFormat(FPB_ALL, FOB_ALL, TRUE, TRUE);
			trAutoRows =tr.Root.Grid.AutoAddRows;
			trAutoRows.nVal = 0;
			wks.ApplyFormat(tr,TRUE, TRUE, TRUE);
			wks.SetSize(nRows,nCols);

			if(!longname)
				wks.HideLabelByType(RCLT_LONG_NAME);
			if(!units)
				wks.HideLabelByType(RCLT_UNIT);
			if(!comments)
				wks.HideLabelByType(RCLT_COMMENT);
		}
	}
	
protected:
	DECLARE_MESSAGE_MAP
	BOOL OnInitSplitter()
	{
		m_bReady = false;
		TreeDynaSplitter::OnInitSplitter(&m_List);
		m_List.SetOutlineBar(flexOutlineBarNone);
		m_List.SetGridLines(flexGridFlatHorz);
		constructTree();
		Show(WORKBOOK_TAB);
		SetReady();
		return true;
	}
	
	BOOL OnDestroy()
	{
		return TreeDynaSplitter::OnDestroy();
	}
	
	void OnRowChange(Control ctrl)
	{
		if(!m_bReady)
			return;
		updateDisplay();
	}
	
private:
	void updateDisplay(bool bNoCheckSelChange = false)
	{
		ShowListContent(-1, true);
	}

	bool constructTree()
	{
		GETN_USE_CURR(m_trNFO);

		// Workbook
		GETN_BEGIN_BRANCH(workbook, _L("Workbook"))
		
			GETN_BEGIN_BRANCH(page, _L("Page"))			//
				GETN_STR(pgname,"Name","Book1")
			GETN_END_BRANCH(page)
			
			GETN_BEGIN_BRANCH(pgctx, _L("Context"))
				GETN_STRLIST(nworksheet,"Worksheet Number","3","1|2|3|4|5")
			GETN_END_BRANCH(pgctx)
	   	GETN_END_BRANCH(workbook)

	   	// Worksheet
		GETN_BEGIN_BRANCH(worksheet,"worksheet")
			GETN_BEGIN_BRANCH(Size, "Size")
		       	GETN_STRLIST(nCols, "Column", "2", "1|2|3|4|5")
				GETN_NUM(nRows, "Row", 32)
			GETN_END_BRANCH(Size)

			GETN_BEGIN_BRANCH(column, _L("Column"))
				GETN_BEGIN_BRANCH(context,_L("Context"))
					GETN_CHECK(longname,"Long Name",TRUE)
					GETN_CHECK(units,"Units",TRUE)
					GETN_CHECK(comments,"Comments",TRUE)
				GETN_END_BRANCH(context)
		   	GETN_END_BRANCH(column)
		GETN_END_BRANCH(worksheet)

  	   	m_trWorkbook = m_trNFO.workbook;
 		m_trWorksheet = m_trNFO.worksheet;

 		return false;
	}
	
private:
	GridTreeControl		m_List;
	Tree				m_trNFO;
	TreeNode 			m_trWorkbook;
	TreeNode 			m_trWorksheet;
	int					m_nSelectRowSetting;
};

BEGIN_MESSAGE_MAP_DERIV(TabSplitter, TreeDynaSplitter)
	ON_INIT(OnInitSplitter)
	ON_DESTROY(OnDestroy)
	ON_GRID_ROW_COL_CHANGE(GetMainPaneID(), OnRowChange)
END_MESSAGE_MAP_DERIV



class SplitterDlg : public Dialog
{
public:
	SplitterDlg() : Dialog(IDD_SPLITTER_DLG, "Splitter")
	{
	}

	int DoModal(HWND hParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}

protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		ON_OK(OnOK)
		ON_CANCEL(OnCancel)
		ON_TAB_SEL_CHANGE(IDC_SETTING_TAB, OnTopTabChange)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnTopTabChange(Control cntrl)
	{
		SetFocus(cntrl.GetSafeHwnd());
		
		int nTabSel = m_TopTab.GetCurSel();
		m_splitter.Show(nTabSel);

		return true;
	}


	BOOL OnInitDialog()
	{
		m_splitter.Init(IDC_GRID, *this, 0, "");
		m_TopTab = GetItem(IDC_SETTING_TAB);
		m_TopTab.InsertItem(WORKBOOK_TAB,_L("Workbook"));
		m_TopTab.InsertItem(WORKSHEET_TAB, _L("Worksheet"));
		return TRUE;
	}

	BOOL OnOK()
	{
		m_splitter.CreateWorkbook();
		return TRUE;
	}
	
	BOOL OnCancel()
	{
		return TRUE;
	}


private:
	TabControl m_TopTab;
	TabSplitter m_splitter;
};
